--[[---------------------------------------------------------------------------
	Chocolatier Two Port Data: Abidjan
	Copyright (c) 2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Characters

DefineCharacter { name = "ab_marketkeep" }
DefineCharacter { name = "ab_farmkeep" }
DefineCharacter { name = "ab_villagekeep" }
DefineCharacter { name = "ab_flowerskeep" }

-------------------------------------------------------------------------------
-- Port Definition

DefinePort
{
	name = "abidjan",
	available = false,
	mapx = 363, mapy = 243, labelpos = kHAlignRight,
	ambient = "sfx/village_loop.ogg",

	layout =
	{
		-- Clouds
		SpriteLayer { image="clouds_03", time=270000, loop=true, htile=true, path={{800,0},{700,0},{100,0},{0,0},}, },
		SpriteLayer { image="clouds_03", time=240000, loop=true, path={{1200,0},{700,0},{100,0},{-400,0}}, },
		
		-- Planes
		SpriteLayer { imagelist=portPlanes, scale=.2, time=10000,hold=30000,random=50,
			path={{-37,-33},{101,16},{716,57},{883,38},},
		},
		
		EmptyBuilding { name="ab_railyard", x=0+314/2,y=32+41/2 },
		SpriteLayer { image="ab_railmask", x=0+343/2,y=72+25/2 },
		
		-- Trains
		SpriteLayer { image="train_02", scale=.2, time=12000,hold=20000,
			path={ {240,66},{200,66},{100,66},{-80,66} } },
		
		SpriteLayer { image="ab_trainmask", x=157+129/2,y=43+31/2 },	

		Market { name="ab_flowers", character="ab_flowerskeep", x=161+114/2,y=105+93/2, ambient="sfx/village_loop.ogg",
			inventory = {orchid=true, rose=true, carnation=true, tulip=true}, dialog="flowers_abidjan", noHaggle=true },
		SpriteLayer { image="ab_flowermask", x=143+150/2,y=122+90/2 },

		-- Boats
		SpriteLayer { imagelist=portBoats, scale=.2, time=45000,hold=10000,bounce=true,
			path={{480,80},{500,80},{772,73},{879,73},},},
		SpriteLayer { image="boat_06", scale=.15, time=103000,hold=5000,bounce=true,
			path={{857,114},{743,110},{463,96},{429,95},}, },
	
		Market { name="ab_market", character="ab_marketkeep", x=454+127/2,y=25+90/2,
			inventory = { cacao = true, sugar=true, coffee=true, almond=true, cashew=true, } },
--		SpriteLayer { image="ab_marketmask", x=431+188/2,y=106+32/2 },
			
		Market { name="ab_farm", character="ab_farmkeep", x=584+216/2,y=173+134/2,
			ambient = "sfx/farm_loop.ogg",
			inventory = { ab_cacao=true}, dialog="farm_abidjan",
		},
--		SpriteLayer { image="ab_farmmask", x=543+257/2,y=0+359/2 },
		SpriteLayer { image="ab_trees", x=607+193/2,y=0+357/2 },
		
		-- Cars, etc
		SpriteLayer { image="car_06", farscale=.4,nearscale=1.0,far=200,near=600, time=12000,hold=10000,
			path={{90,229},{322,299},{721,404},{738,542},},
		},
		
		SpriteLayer { image="ab_roadmaskA", x=0+241/2,y=172+119/2 },
		SpriteLayer { image="ab_roadmaskB", x=211+131/2,y=279+91/2 },
		
		EmptyBuilding { name="ab_village", character= {"ab_villagekeep"}, x=10+502/2,y=250+133/2 },
		SpriteLayer { image="ab_villagemask", x=0+599/2,y=346+75/2 },
	}
}